﻿package {
	import flash.events.*;
	import flash.display.*;

	public class TopPanel extends MovieClip{
		public var dispatcher:EventDispatcher = new EventDispatcher();
		
		public var frameNormal = 1;
		public var frameDisabled = 2;
		public var frameMouseOver = 3;
		
		//inline items:
		//mc_uploadItem
		//mc_deleteItem
		//mc_editNameItem
		//mc_editDescItem
		//mc_selectAllItem
		//mc_deleteCategory
		//mc_addCategory
		//mc_editNameCategory
		//mc_deleteCategory
		//mc_backCategories
		//mc_backItems
		//mc_duplicateItem
		//mc_downloadItem
		//mc_previewItem
		//mc_devider1
		//mc_devider2
		//mc_devider3		
		//mc_devider4
		//mc_devider3
		//mc_devider5
		//mc_devider6
		//mc_devider7
		
		//constructor:
		public function TopPanel(){
			initButton(mc_uploadItem);
			initButton(mc_deleteItem);
			initButton(mc_editNameItem);
			initButton(mc_editDescItem);
			initButton(mc_selectAllItem);
			initButton(mc_addCategory);
			initButton(mc_editNameCategory);
			initButton(mc_deleteCategory);
			
			initButton(mc_duplicateItem);
			initButton(mc_downloadItem);
			initButton(mc_previewItem);
			
			enableItemSelectedButtons(false,0);	//disable top buttons
		}
		
		//---------------------------------------------------------------------		
		//resets panel button
		public function reset(){
			enableItemSelectedButtons(false,0);	//disable top buttons
		}
		
		//---------------------------------------------------------------------		
		//set button it's properties.
		public function initButton(mc_button){
			mc_button.buttonMode = true;
			mc_button.mouseChildren = false;
			
			//set button events:
			mc_button.addEventListener(MouseEvent.MOUSE_UP, onbuttonMouseUp);
			mc_button.addEventListener(MouseEvent.MOUSE_OVER, onbuttonMouseOver);
			mc_button.addEventListener(MouseEvent.MOUSE_OUT, onbuttonMouseOut);
		}
		
		//---------------------------------------------------------------------		
		// button mouse over - switch to over frame.
		public function onbuttonMouseOver(event:MouseEvent){
			var mc_button = event.target;
			mc_button.gotoAndStop(this.frameMouseOver);
		}
		
		//---------------------------------------------------------------------		
		// button mouse out - switch to normal frame.
		public function onbuttonMouseOut(event:MouseEvent){
			var mc_button = event.target;
			mc_button.gotoAndStop(this.frameNormal);
		}
		
		//---------------------------------------------------------------------		
		// disable some button
		public function disableButton(mc_button){
			mc_button.mouseEnabled = false;
			mc_button.gotoAndStop(this.frameDisabled);
		}
		
		//---------------------------------------------------------------------		
		// enable some button
		public function enableButton(mc_button){
			mc_button.mouseEnabled = true;
			mc_button.gotoAndStop(this.frameNormal);
		}
		
		//---------------------------------------------------------------------		
		// hide or show some section
		public function enableItemSelectedButtons(enable:Boolean,numItems:Number){
			if(enable == true){
				enableButton(this.mc_deleteItem);
				
				//items that corresponds to one selected item.
				if(numItems == 1){
					enableButton(this.mc_editNameItem);
					enableButton(this.mc_editDescItem);				
					enableButton(this.mc_duplicateItem);
					enableButton(this.mc_downloadItem);
					enableButton(this.mc_previewItem);
				}
				else{
					disableButton(this.mc_editNameItem);
					disableButton(this.mc_editDescItem);				
					disableButton(this.mc_duplicateItem);
					disableButton(this.mc_downloadItem);
					disableButton(this.mc_previewItem);
				}

			}
			else{
				disableButton(this.mc_editNameItem);
				disableButton(this.mc_editDescItem);
				disableButton(this.mc_deleteItem);				
				disableButton(this.mc_duplicateItem);
				disableButton(this.mc_downloadItem);
				disableButton(this.mc_previewItem);
			}
		}				
		
		//---------------------------------------------------------------------		
		// enable or disable category selected buttons
		public function enableCategorySelectedButtons(enable:Boolean){
			if(enable){
				enableButton(mc_deleteCategory);
				enableButton(mc_editNameCategory);
			}
			else{	//disable
				disableButton(mc_deleteCategory);
				disableButton(mc_editNameCategory);
			}
		}
		
		//---------------------------------------------------------------------		
		// hide or show some section
		private function hideShowSection(section:String,show:Boolean){
			switch(section){
				case "items":
					mc_backItems.visible = show;
					
					//hide buttons
					mc_editNameItem.visible = show;
					mc_uploadItem.visible = show;
					mc_deleteItem.visible = show;
					mc_selectAllItem.visible = show;
					mc_editDescItem.visible = show;					
					mc_duplicateItem.visible = show;
					mc_previewItem.visible = show;
					mc_downloadItem.visible = show;
					
					//hide deviders
					mc_devider1.visible = show;
					mc_devider2.visible = show;
					mc_devider3.visible = show;
					mc_devider4.visible = show;
					mc_devider5.visible = show;
					mc_devider6.visible = show;
					mc_devider7.visible = show;					
				break;
			}
		}
		
		//--------------------------------------------------------------------		
		// hide background and all buttons of some section.
		public function hideSection(section:String){
			hideShowSection(section,false);
		}
		
		//---------------------------------------------------------------------		
		// hide background and all buttons of some section.
		public function showSection(section:String){
			hideShowSection(section,true);
		}
		
		//---------------------------------------------------------------------
		// buton mouse up handler
		private function onbuttonMouseUp(event:MouseEvent){
			switch(event.target.name){
				case "mc_uploadItem":
					dispatchCustomEvent("uploadButtonClick");
				break;
				case "mc_deleteItem":
					dispatchCustomEvent("deleteButtonClick");
				break;
				case "mc_editNameItem":
					dispatchCustomEvent("editNameClick");
				break;
				case "mc_editDescItem":
					dispatchCustomEvent("editDescClick");
				break;
				case "mc_selectAllItem":
					dispatchCustomEvent("selectAllClick");
				break;
				case "mc_addCategory":
					dispatchCustomEvent("addCategoryClick");
				break;
				case "mc_editNameCategory":
					dispatchCustomEvent("editNameCategoryClick");
				break;
				case "mc_deleteCategory":
					dispatchCustomEvent("deleteCategoryClick");
				break;
				case "mc_duplicateItem":
					dispatchCustomEvent("duplicateItemClick");
				break;
				case "mc_downloadItem":
					dispatchCustomEvent("downloadItemClick");
				break;
				case "mc_previewItem":
					dispatchCustomEvent("previewItemClick");
				break;
				default:
					trace("TopPanel - onbuttonMouseUp error - wrong button name: " + event.target.name);
				break;
			}
		}
		
		//---------------------------------------------------------------------
		//dispatch custom event
		public function dispatchCustomEvent(eventName:String){
			dispatcher.dispatchEvent(new Event(eventName));
		}
	}
}